#ifndef _LED_H_
#define _LED_H_

#include "ht32f520xx_01.h"

#define	_LED1_IO_	14       /* PA14 */ 																						
#define	_LED2_IO_	11       /* PA11 */
#define	_LED3_IO_	10       /* PA10 */
#define	_LED4_IO_	8        /* PA8 */

#define	LED1_PORT				HT_GPIOA
#define	LED1_PORT_NUM		GPIO_PA
#define	LED2_PORT				HT_GPIOA
#define	LED2_PORT_NUM		GPIO_PA
#define	LED3_PORT				HT_GPIOA 																						
#define	LED3_PORT_NUM		GPIO_PA
#define	LED4_PORT				HT_GPIOA
#define	LED4_PORT_NUM		GPIO_PA

#define	LED1_ON			LED1_PORT->DOUTR &= ~(1UL << _LED1_IO_)
#define	LED1_OFF		LED1_PORT->DOUTR |= (1UL << _LED1_IO_)
#define	LED1_TOGGLE	LED1_PORT->DOUTR ^= (1UL << _LED1_IO_)
#define	LED2_ON			LED2_PORT->DOUTR &= ~(1UL << _LED2_IO_)
#define	LED2_OFF		LED2_PORT->DOUTR |= (1UL << _LED2_IO_)
#define	LED2_TOGGLE	LED2_PORT->DOUTR ^= (1UL << _LED2_IO_)
#define	LED3_ON			LED3_PORT->DOUTR &= ~(1UL << _LED3_IO_) 																					
#define	LED3_OFF		LED3_PORT->DOUTR |= (1UL << _LED3_IO_)
#define	LED3_TOGGLE	LED3_PORT->DOUTR ^= (1UL << _LED3_IO_)
#define	LED4_ON			LED4_PORT->DOUTR &= ~(1UL << _LED4_IO_)
#define	LED4_OFF		LED4_PORT->DOUTR |= (1UL << _LED4_IO_)
#define	LED4_TOGGLE	LED4_PORT->DOUTR ^= (1UL << _LED4_IO_)

#define  LED1     	1 																						
#define  LED2     	2
#define  LED3     	3
#define  LED4     	4



void LED_IO_configure(void);
void LED_always_on(u8 led);
void LED_always_off(u8 led);
void LED_flash_enable(u8 led,u16 timer);
void LED_flash_process(void);
void LEDProcess_ms(void);
void LED_EnableFlag_ms(u8 led,u16 timer);
void LED_All_ON(void);
void LED_All_OFF(void);

#endif /* _LED_H_ */
